package cn.com.duiba.galaxy.sdk.apiextra;


import cn.com.duiba.galaxy.sdk.DuibaApi;
import cn.com.duiba.galaxy.sdk.template.DistributedLock;
import cn.com.duiba.galaxy.sdk.transaction.ProjectTransactionApi;

/**
 * 定时任务作用域下的API
 *
 * @author xuhengfei
 */
public interface TimerApi {

//    /**
//     * 直接发奖，不通过发奖规则进行发奖
//     * @param strategyId 策略id
//     * @param userId userId
//     * @param prizeId prizeId
//     * @return SendPrizeResult
//     */
//    SendPrizeResult sendPrize(String strategyId, String userId, String prizeId);
//
//    /**
//     * 直接给用户增加积分
//     * 没有用户中奖记录
//     * 如果发放失败则抛运行时异常
//     * @param userId 用户id 不能为空
//     * @param quantity 积分数量 不能为空
//     * @param description 描述，需要定制时通过该参数, 可以为空
//     */
//    void sendCreditsPrize(String userId, Long quantity, String description);
//    void sendCreditsPrize(String userId, Long quantity, String description, String transfer);
//
//    /**
//     * 获取运营配置的变量Integer
//     *
//     * @param key 配置项Variable
//     * @return 变量对应的int值
//     */
//    Integer getIntVariable(String key);
//
//    /**
//     * 获取运营配置变量Date
//     *
//     * @param key 配置项Variable
//     * @return 变量对应的Date值
//     */
//    Date getDateVariable(String key);
//
//    /**
//     * 获取运营配置变量String
//     *
//     * @param key 配置项Variable
//     * @return 变量对应的String值
//     */
//    String getStringVariable(String key);
//
//    /**
//     * 获取运营配置变量 image类型
//     * @param key
//     * @return
//     */
//    String getImageVariable(String key);

    /**
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);

    /**
     * 消耗用户道具
     *
     * @param userId
     * @param spId
     * @param quantity
     * @return
     */
    Boolean consumeStageProperty(String userId, String spId, int quantity);

    Long getSomebodyStageProperty(String userId, String spId);
//
//    /**
//     * 获取白名单用户list
//     *
//     * @param groupId 白名单分组ID
//     * @return
//     */
//    List<String> getWhiteUserIdsByGroup(String groupId);
//
//    /**
//     * 获取一个QueryTable实例
//     *
//     * @param group 数据分组
//     * @param clazz 映射类型
//     * @param <T>
//     * @return
//     */
//    <T extends Field> QueryTable<T> getTable(String group, Class<T> clazz);
//
//    /**
//     * 获取某个发奖策略下的所有奖项
//     * @param strategyId 发奖策略id
//     * @return 奖项列表
//     */
//    List<Option> queryOptions(String strategyId);
//
//    /**
//     * 获取一个http请求实例,不同project之间相互隔离
//     *
//     * @return
//     */
//    HttpHelper getHttpHelper();
//
//    /**
//     * 获取一个https请求实例
//     *
//     * @param name     实例的名称，不同实例间隔离
//     * @param keyStore 证书
//     * @return
//     */
//    HttpHelper getHttpHelper(String name, KeyStore keyStore);
//
//    /**
//     * 获取通知api
//     *
//     * @return
//     */
//    NotifyApi getNotifyApi();

    /**
     * 获取key-value存储功能API
     *
     * @return
     */
    KeyValueApi getKeyValueApi();

    DuibaApi getDuibaApi();
//
//    UserRelationApi getUserRelationApi();
//
//    /**
//     * 扣减拖管积分
//     * 注意：此方法只针对兑吧拖管积分
//     * 调credits-center接口扣减拖管积分
//     * @param creditsParamData
//     * @return
//     */
//    Boolean subTrustCredits(CreditsParamData creditsParamData);
//
//    /**
//     * 增加拖管积分
//     * 注意：此方法只针对兑吧拖管积分
//     * 调credits-center接口增加拖管积分
//     * @param creditsParamData
//     * @return
//     */
//    Boolean addTrustCredits(CreditsParamData creditsParamData);
//
//    /**
//     * 查询拖管积分
//     * 注意：此方法只针对兑吧拖管积分
//     * 调credits-center接口查询拖管积分
//     * @param userId
//     * @return
//     */
//    Long queryTrustCreditsByConsumerId(String userId);

    /**
     * 返回projectId
     *
     * @return
     */
    String getProjectId();
//
//    /**
//     * 获取指定奖品库存信息
//     * @return
//     */
//    PrizeStock getPrizeStock(String prizeId);
//
//    /**
//     * 获取组件Api
//     */
//    ComponentTimerApi getComponentTimerApi();
//
//    /**
//     * 获取QueryTableSp实例
//     * @param clazz 数据模型class对象
//     * @param <T> 数据模型类型
//     * @return 实例
//     */
//    <T> QueryTableSp<T> getQueryTableSp(Class<T> clazz);
//
//    /**
//     * 获取RedisApi实例
//     * @return RedisApi
//     */
//    RedisApi getRedisApi();
//
//    /**
//     * 获取发送消息的MqApi
//     * @return MqApi
//     */
//    MqApi getMqApi();
//
//    /**
//     * 获取平台sdk埋点api
//     * cf文档地址 http://cf.dui88.com/pages/viewpage.action?pageId=120126897
//     * @return
//     */
//    SdkLogApi getSdkLogApi();
//
//
//
//    /**
//     * 根据groupId获取白名单用户信息
//     * @param groupId
//     * @param page
//     * @param pageSize
//     * @param startId 开始id，包括此id，可以为空
//     * @return
//     */
//    PageList<ProjectWhiteListData> listWhiteByGroupId(String groupId, int page, int pageSize, Long startId);

    DistributedLock newLock(String key, int expireSeconds);

    /**
     * 获取事务执行API
     *
     * @return projectTransactionApi
     */
    ProjectTransactionApi getTransactionApi();
}
