package cn.com.duiba.galaxy.sdk.message;

/**
 * 系统模块枚举
 *
 * @author fangxiaorun
 * @date 2022/09/28
 */
public enum SystemModuleEnum {
    /**
     * APP 端（开发C端活动时使用该类型）
     */
    APP("A00", "APP端"),
    /**
     * 平台管理后台模块
     */
    PLATFORM_CONSOLE("P01", "管理后台模块"),
    /**
     * 平台核心业务模块（如：玩法、组件、发奖策略等）
     */
    PLATFORM_CORE("P02", "核心业务模块"),
    /**
     * 平台基础服务模块
     */
    PLATFORM_BASIC("P03", "基础服务模块"),
    /**
     * 平台SDK模块（提供给作业端开发C端活动）
     */
    PLATFORM_SDK("P04", "平台SDK模块"),
    /**
     * 平台API模块（提供给外部系统，如：扣积分回调，支付回调等场景）
     */
    PLATFORM_API("P05", "平台API模块"),
    /**
     * 平台适配器模块
     */
    PLATFORM_ADAPTER("P06", "平台适配器模块"),
    /**
     * 平台热加载/部署模块
     */
    PLATFORM_LOAD("P07", "平台热加载/部署模块"),
    /**
     * 未分类
     */
    UNCLASSIFIED("000", "未分类");

    /**
     * 编码
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    SystemModuleEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}