package cn.com.duiba.galaxy.sdk.playway.join;


import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinPlayway;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinRecord;
import cn.com.duiba.galaxy.sdk.playway.join.inner.JoinUserRequestApi;
import cn.com.duiba.galaxy.sdk.template.DistributedLock;
import cn.com.duiba.galaxy.sdk.utils.Conditions;
import cn.com.duiba.wolf.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 参与玩法
 * copy from ProjectX
 * 若要重写实现，请在子类重新添加 @CustomRequestAction 注解
 */
@Slf4j
public abstract class AbstractJoinPlaywayImpl implements JoinPlayway {


    @Override
    @CustomRequestAction(id = "queryMyJoinCount", desc = "查询我的参与信息")
    public Map<String, Object> queryMyJoinCount(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        Long total = joinUserRequestApi.queryMyAllCount();
        Long today = joinUserRequestApi.queryMyTodayCount();

        Map<String, Object> map = new HashMap<>();
        map.put("total", total);
        map.put("today", today);

        return map;
    }

    @Override
    @CustomRequestAction(id = "queryMyJoinRecord", desc = "查询我的参与记录")
    public List<JoinRecord> queryMyJoinRecord(UserRequestContext context, JoinUserRequestApi joinUserRequestApi) {
        String start = context.getHttpRequest().getParameter("start");
        String end = context.getHttpRequest().getParameter("end");
        List<JoinRecord> records;
        if(StringUtils.isNotEmpty(start) && StringUtils.isNotEmpty(end)){
            Date startDate = DateUtils.getDayDate(start);
            Date endDate = DateUtils.getDayDate(end);
            records = joinUserRequestApi.queryMyRecords(startDate,endDate);
        }else{
            records = joinUserRequestApi.queryMyRecentRecord(200);
        }
        return records;
    }


    @Override
    @CustomRequestAction(id = "join", desc = "参与")
    public Boolean join(UserRequestContext context, JoinUserRequestApi joinUserRequestApi){
        DistributedLock lock= joinUserRequestApi.getMyUserContext().getMyLock();
        boolean get = lock.tryLock(1,50L);
        Conditions.expectTrue(get, UnclassifiedStatusEnum.LOCK_FAILD);

        try{
            log.info("加锁成功");
            return doJoin(context,joinUserRequestApi);
        }finally {
            lock.unlock();
            log.info("解锁成功");
        }
    }

    public abstract Boolean doJoin(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


}
