package cn.com.duiba.galaxy.sdk.playway.join.inner;

import cn.com.duiba.galaxy.sdk.UserRequestContext;
import cn.com.duiba.galaxy.sdk.playway.PlaywayInterface;

/**
 * 参与玩法
 * 业务代码请不要显示继承实现此类
 * 否则一旦需要添加新方法，线上已有代码会因未实现新方法而报错。
 * 请继承提供的抽象类
 */
public interface JoinPlayway extends PlaywayInterface {

    /**
     * queryMyJoin:查询我的参与信息
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    Object queryMyJoinCount(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);

    /**
     * queryMyJoinRecord:查询我的参与记录
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    Object queryMyJoinRecord(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


    /**
     * join:参与
     * @param context
     * @param joinUserRequestApi
     * @return
     */
    Object join(UserRequestContext context, JoinUserRequestApi joinUserRequestApi);


}