package cn.com.duiba.galaxy.sdk.api.http;

import cn.com.duiba.galaxy.sdk.api.http.inner.HttpHelper;
import org.apache.http.nio.client.HttpAsyncClient;
import org.springframework.web.client.RestTemplate;

/**
 * @author jiaxz
 * @since 2022-12-30
 */
public interface HttpApi {
    /**
     * 获取一个http请求实例,不同project之间相互隔离
     *
     * @return
     */
    HttpHelper getHttpHelper();

    /**
     * 获取 loadBalancedRestTemplate
     *
     * 通过 @LoadBalanced 注解的 RestTemplate 的Bean，可以作为 Load Balancer Client 来使用
     * @return
     */
    RestTemplate getLoadBalancedRestTemplate();

    /**
     * 获取异步http请求实例
     * @return
     */
    HttpAsyncClient getHttpAsyncClient();
}
