package cn.com.duiba.galaxy.sdk.api.http.inner;

import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.web.context.request.async.DeferredResult;

import java.util.Map;

/**
 * 异步 Http 请求类
 */
public interface HttpAsyncClient {

    /**
     * 提交一个异步get请求
     *
     * @param url      请求地址
     * @param params   请求参数
     * @param callbackRes   异步回调函数
     */
    void submitGet(String url, Map<String, String> params, HttpCallbackResponse callbackRes);

    /**
     * 提交一个异步get请求
     *
     * @param request   请求的抽象，可以是httppost，也可以是httpurl
     * @param callbackRes   异步回调函数,其泛形为如参的类型
     * @param bizParam   异步回调函数中需要的自定义参数
     */
     void submit(HttpRequestBase request, HttpCallbackResponse<?> callbackRes, Object bizParam);


    /**
     * test
     * @param request   请求的抽象，可以是httppost，也可以是httpurl
     * @param callbackRes   异步回调函数,返回会被输出给前端页面
     * @param bizParam   异步回调函数中需要的自定义参数
     * @return  DeferredResult：springmvc提供的基于回调的异步servlet实现,需返回该对象给controller。
     */
     DeferredResult<String> asyncSubmitAndSyncReturn(HttpRequestBase request, HttpCallbackResponse<?> callbackRes, Object bizParam);

}
