package cn.com.duiba.galaxy.sdk.base;

/**
 * @author zhangruofan
 * @date 2019/12/02
 */
public interface CreditsRecord {

    public static final String TICKET_NUM = "ticketNum";

    /**
     * 获取门票num
     *
     * @return 门票唯一标识码 32位UUID
     */
    String getTicketNum();

    /**
     * 返回project id
     *
     * @return project id
     */
    Long getProjectId();

    /**
     * 返回playwayId
     * @return playwayId
     */
    String getPlaywayId();

    /**
     * 返回actionId
     * @return actionId
     */
    String getActionId();

    /**
     * 返回userId
     *
     * @return userId
     */
    Long getUserId();

    /**
     * 返回扣得积分数
     * @return quantity
     */
    Long getQuantity();

    /**
     * 领取状态  0:处理中，1:门票领取成功，2:领取失败
     * @return 领取状态
     */
    Integer getState();

    /**
     * 是否使用 true 已使用 false 未使用
     * @return 是否使用
     */
    Boolean getUsed();

    /**
     * 使用方记录Id
     * @return 使用方记录id
     */
    Long getUseSideRecordId();

    /**
     * 开发者扣积分流水号
     * @return 开发者扣积分流水号
     */
    String getBizId();

    /**
     * 扩展字段
     * @return 扩展字段
     */
    String getExtra();
}
