package cn.com.duiba.galaxy.sdk.pay.gh.gd;

import java.io.Serializable;
import java.util.List;

/**
 * Description:
 * <p> 华兴银行支付-商品信息集合
 * date: 2022/8/22 11:52 上午
 *
 */
public class GdhxGoodsInfo implements Serializable {

    /**
     * 奖品id
     */
    private String prizeId;
    /**
     * 奖品明称
     */
    private String prizeName;

    /**
     * 奖品供应商
     */
    private String provider = "杭州兑吧";

    /**
     * 奖品数量
     */
    private Integer prizeNum = 1;

    /**
     * 手续费
     */
    private Integer serviceFee = 0;

    /**
     * 商品价格集合信息
     */
    private List<GdhxPriceInfo> priceInfos;

    public GdhxGoodsInfo() {
    }

    public GdhxGoodsInfo(String prizeId, String prizeName, List<GdhxPriceInfo> priceInfos) {
        this.prizeId = prizeId;
        this.prizeName = prizeName;
        this.priceInfos = priceInfos;
    }

    public GdhxGoodsInfo(String prizeId, String prizeName, String provider, Integer prizeNum, Integer serviceFee, List<GdhxPriceInfo> priceInfos) {
        this.prizeId = prizeId;
        this.prizeName = prizeName;
        this.provider = provider;
        this.prizeNum = prizeNum;
        this.serviceFee = serviceFee;
        this.priceInfos = priceInfos;
    }

    public String getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(String prizeId) {
        this.prizeId = prizeId;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Integer getPrizeNum() {
        return prizeNum;
    }

    public void setPrizeNum(Integer prizeNum) {
        this.prizeNum = prizeNum;
    }

    public Integer getServiceFee() {
        return serviceFee;
    }

    public void setServiceFee(Integer serviceFee) {
        this.serviceFee = serviceFee;
    }

    public List<GdhxPriceInfo> getPriceInfos() {
        return priceInfos;
    }

    public void setPriceInfos(List<GdhxPriceInfo> priceInfos) {
        this.priceInfos = priceInfos;
    }


}
