package cn.com.duiba.galaxy.sdk.pay.icbc.elife;

import cn.com.duiba.galaxy.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * Created by HePeng on 2022/06/13 14:37.
 */
public class IcbcElifeWxPayReq extends BasePayReq {
    private static final long serialVersionUID = -2127748521249604325L;

    /**
     * 业务ID，业务方根据需要自定义
     */
    @NotNull
    private String bizId;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "缺少支付金额")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 商户附加数据，最多21个汉字字符（为便于区分统计，小程序支付时，请上送“OFSTMINI:活动号”，支付完成后，按照活动号进行跳转）
     */
    private String attach;

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }
}
