package cn.com.duiba.galaxy.sdk.pay.wx;

import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 微信转账订单请求
 *
 */
public class WxTransferPaySendReq implements Serializable {
    private static final long serialVersionUID = -202691032793973285L;

    /**
     * 用户openid
     * 此 openId 归属于 上游APP的"业务主体"，而非上游业务APP
     */
    @NotBlank(message = "openId不能为空")
    private String openId;

    /**
     * 付款金额/红包总金额，单位分（微信支付要求最新金额不能低于30分）
     */
    @Min(value = 0, message = "amount不能小于0")
    @NotNull(message = "amount不能为空")
    private Integer amount;

    /**
     * 调用接口的机器Ip地址
     */
    @NotBlank(message = "ip不能为空")
    private String spbillCreateIp;

    /**
     * 备注
     */
    @NotBlank(message = "desc不能为空")
    private String desc;

    /**
     * 0:不校验真实姓名 , 1:强校验真实姓名
     */
    @NotNull(message = "checkName不能为空")
    private Integer checkName;

    /**
     * 设备号
     */
    private String deviceInfo;


    /**
     * 支付渠道 (使用wx_change，即使不传，paycent也会默认使用这个字段)
     */
    private String channelType;

    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型（paycenter会从开发者信息里取业务主体）
     *
     */
    private String subjectType;

    /**
     * 业务方关联活动类型（ 星速台使用 31020 ）
     * @see cn.com.duiba.projectx.sdk.redacc.ActivityUniformityTypeEnum
     */
    @NotNull(message = "bizRelationType不能为空")
    private Integer bizRelationType;

    /**
     * 业务方关联活动id(星速台活动id)
     */
    @NotBlank(message = "bizRelationId不能为空")
    private String bizRelationId;

    /**
     * 业务方订单号
     */
    @NotBlank(message = "bizOrderNo不能为空")
    private String bizOrderNo;


    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public Integer getBizRelationType() {
        return bizRelationType;
    }

    public void setBizRelationType(Integer bizRelationType) {
        this.bizRelationType = bizRelationType;
    }

    public String getBizRelationId() {
        return bizRelationId;
    }

    public void setBizRelationId(String bizRelationId) {
        this.bizRelationId = bizRelationId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getSpbillCreateIp() {
        return spbillCreateIp;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCheckName() {
        return checkName;
    }

    public void setCheckName(Integer checkName) {
        this.checkName = checkName;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }
}
