package cn.com.duiba.galaxy.sdk.pay.api;

import cn.com.duiba.galaxy.sdk.pay.PayRecordDto;
import cn.com.duiba.galaxy.sdk.pay.ccb.CcbChargeRequest;
import cn.com.duiba.galaxy.sdk.pay.ccb.CcbChargeResponse;
import cn.com.duiba.galaxy.sdk.pay.ccb.CcbPayNotifyResp;


import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 建行支付API
 *
 * @author fxr
 * @date 2020-6-30
 */
public interface CcbPayApi {

    /**
     * 创建支付
     *
     * @param request 请求
     * @return {@link CcbChargeResponse}
     */
    CcbChargeResponse createCharge(CcbChargeRequest request);


    /**
     * 建行支付结果通知
     *
     * @param map map
     * @return {@link CcbPayNotifyResp}
     */
    CcbPayNotifyResp orderNotify(Map<String, String> map);


    /**
     * 根据支付记录id查询支付记录
     *
     * @param id id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findPayRecordById(Long id);


    /**
     * 查询用户最近一个进行中的订单
     *
     * @param userId    用户id
     * @return {@link PayRecordDto}
     */
    PayRecordDto findLastGoingOrder(String userId,String projectId);

    /**
     * 查询过期未结束订单数量
     */
    int countTimeOutRecords(Date gmtCreate,String projectId);

    /**
     * 分页查询过期未结束订单
     */
    List<PayRecordDto> findTimeOutRecordsPage(Date gmtCreate, int offset, int size,String projectId);

    /**
     * 更新状态
     */
    int updateStatus(Long id, int newStatus, int oldStatus, String extra);
}
