package cn.com.duiba.galaxy.sdk.pay.gh.gd;

import java.io.Serializable;

/**
 * Description:
 * <p> 华兴银行支付-商品统计信息
 * date: 2022/8/22 11:52 上午
 *
 * @author huakai
 */
public class GdhxRefundStatInfo implements Serializable {

    /**
     * 订单总金额
     * NUMBER(10)
     * (一笔订单总积分或总金额)
     */
    private String totalValue;
    /**
     * 消费类型
     * P：积分
     * C：现金（秒杀活动送C）
     */
    private String type;

    /**
     * 奖品编号
     */
    private String prizeId;

    public String getPrizeId() {
        return prizeId;
    }

    public void setPrizeId(String prizeId) {
        this.prizeId = prizeId;
    }

    public GdhxRefundStatInfo() {
    }

    public GdhxRefundStatInfo(String totalValue, String type) {
        this.totalValue = totalValue;
        this.type = type;
    }

    public String getTotalValue() {
        return totalValue;
    }

    public GdhxRefundStatInfo setTotalValue(String totalValue) {
        this.totalValue = totalValue;
        return this;
    }

    public String getType() {
        return type;
    }

    public GdhxRefundStatInfo setType(String type) {
        this.type = type;
        return this;
    }
}
