package cn.com.duiba.galaxy.sdk.pay.wx;

import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zdq
 * @Description
 * @createTime 2021年10月13日 11:41:00
 */
public class WxPayRedPacketSendReq implements Serializable {

    /**
     * 支付渠道(固定"wx_red_packet"，可不传)
     *
     */
    private String channelType;

    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 --（通过appid查询，无需业务方查询）
     *
     */
    private String subjectType;

    /**
     * 业务方关联活动类型
     *
     */
    @NotNull(message = "bizRelationType不能为空")
    private Integer bizRelationType;

    /**
     * 业务方关联活动id
     */
    @NotBlank(message = "bizRelationId不能为空")
    private String bizRelationId;

    /**
     * 业务方订单号
     */
    @NotBlank(message = "bizOrderNo不能为空")
    private String bizOrderNo;

    /**
     * 红包发送者名称
     */
    @NotBlank(message = "sendName不能为空")
    private String sendName;

    /**
     * 接受红包的用户openid
     * 此 openId 归属于 上游APP的"业务主体"，而非上游业务APP
     */
    @NotBlank(message = "reOpenid不能为空")
    private String reOpenid;

    /**
     * 付款金额/红包总金额，单位分
     */
    @Min(value = 0, message = "totalAmount不能小于0")
    @NotNull(message = "totalAmount不能为空")
    private Integer totalAmount;

    /**
     * 红包发放总人数
     */
    @Min(value = 0, message = "totalNum不能小于0")
    @NotNull(message = "totalNum不能为空")
    private Integer totalNum;

    /**
     * 红包祝福语
     */
    @NotBlank(message = "wishing不能为空")
    private String wishing;

    /**
     * 调用接口的机器Ip地址
     */
    @NotBlank(message = "clientIp不能为空")
    private String clientIp;

    /**
     * 活动名称
     */
    @NotBlank(message = "actName不能为空")
    private String actName;

    /**
     * 备注
     */
    @NotBlank(message = "remark不能为空")
    private String remark;

    /**
     * 场景id，发放红包使用场景，红包金额大于200或者小于1元时必传
     *
     * @see
     */
    @NotBlank(message = "sceneId不能为空")
    private String sceneId;

    /**
     * 活动信息
     */
    private String riskInfo;

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public Integer getBizRelationType() {
        return bizRelationType;
    }

    public void setBizRelationType(Integer bizRelationType) {
        this.bizRelationType = bizRelationType;
    }

    public String getBizRelationId() {
        return bizRelationId;
    }

    public void setBizRelationId(String bizRelationId) {
        this.bizRelationId = bizRelationId;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public String getSendName() {
        return sendName;
    }

    public void setSendName(String sendName) {
        this.sendName = sendName;
    }

    public String getReOpenid() {
        return reOpenid;
    }

    public void setReOpenid(String reOpenid) {
        this.reOpenid = reOpenid;
    }

    public Integer getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public String getWishing() {
        return wishing;
    }

    public void setWishing(String wishing) {
        this.wishing = wishing;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getActName() {
        return actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSceneId() {
        return sceneId;
    }

    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public String getRiskInfo() {
        return riskInfo;
    }

    public void setRiskInfo(String riskInfo) {
        this.riskInfo = riskInfo;
    }
}
