package cn.com.duiba.live.activity.center.api.enums.scene;

import cn.com.duiba.kjy.api.util.BitUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动生效场景枚举
 * @author ouyang
 * @date 2021-10-30
 **/
@AllArgsConstructor
@Getter
public enum LiveActivitySceneEnum {

    LIVE_HOME_PAGE(0, "直播首页"),
    LIVE_END_PAGE(1, "直播结束页"),
    LIVE_APPOINTMENT(2, "直播预约"),
    LIVE_BROADCASTING_ROOM(3, "直播间")
    ;



    /**
     * 在二进制中的位置（从右往左第几位，从0开始）
     */
    private Integer position;

    /**
     * 描述
     */
    private String desc;

    //全部元素
    private static final Map<Integer, LiveActivitySceneEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveActivitySceneEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getPosition(), configEnum);
        }
    }

    public static Map<Integer, LiveActivitySceneEnum> getEnumMap() {
        return ENUM_MAP;
    }


    /**
     * 添加场景
     * @param on 所有直播场景十进制值
     * @param position 要添加的直播场景
     * @return 添加后的直播场景十进制值
     */
    public static long addScene(long on, Integer position) {
        if (position == null) {
            return on;
        }
        return BitUtils.addBit(on, position);
    }

    /**
     * 获取场景
     * @param on 所有直播场景十进制值
     * @param scene 要获取的直播场景
     * @return 获取场景是否生效
     */
    public static long getScene(Long on, LiveActivitySceneEnum scene) {
        //0为默认值全场景生效
        if (on == null || on == 0) {
            return 1;
        }
        return BitUtils.valueOfBit(on,scene.getPosition());
    }


}
