package cn.com.duiba.live.activity.center.api.dto.flipword;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2021/06/28 5:13 下午
 * @description 翻牌集字 - 翻牌结果信息
 */
@Data
public class FlipWordDetailDto implements Serializable {

    private static final long serialVersionUID = -6047679141471239004L;

    /**
     * 翻牌结果类型
     *
     * @see cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordResultTypeEnum
     */
    private Integer resultType;

    /**
     * 翻牌位置
     */
    private Integer pos;

    /**
     * 翻牌时间
     */
    private Date turnTime;

    /**
     * 翻牌渠道
     *
     * @see cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordHelpStatusEnum
     */
    private Integer helpState;
}
