package cn.com.duiba.live.activity.center.api.remoteservice.marketcoupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.marketcoupon.MarketRightsDto;
import cn.com.duiba.live.activity.center.api.param.marketcoupon.MarketRightsSearchParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMarketRightsService {

    /**
     * 查询数量
     * @param param 查询条件
     * @return 数目
     */
    Long countByParam(MarketRightsSearchParam param);

    /**
     * 分页查询
     * @param param 查询条件
     * @return 列表
     */
    List<MarketRightsDto> pageByParam(MarketRightsSearchParam param);

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    MarketRightsDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param marketRightsDto 实例对象
     * @return 实例对象
     */
    long save(MarketRightsDto marketRightsDto);

    /**
     * 修改数据
     *
     * @param marketRightsDto 实例对象
     * @return 实例对象
     */
    int update(MarketRightsDto marketRightsDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);
}
