package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.UserPointRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022-03-30 11：09
 * @description 用户积分流水 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointRecordService {

    /**
     * 新增流水记录
     *
     * @param dto 流水记录
     * @return 执行结果
     */
    int insert(UserPointRecordDto dto);

    /**
     * 查询指定时间区间的流水记录
     *
     * @param userPointId 用户积分记录Id
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @return 流水记录集合
     */
    List<UserPointRecordDto> listByUserPointIdAndTimeInterval(Long userPointId, Date startTime, Date endTime);

}
