package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.UserPointDto;

/**
 * @author zhuenhui
 * @date 2022-03-30 11：09
 * @description 用户积分记录 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointService {

    /**
     * 新增
     *
     * @param dto 用户积分详情
     * @return 主键Id
     */
    Long insert(UserPointDto dto);

    /**
     * 更新
     *
     * @param dto 用户积分详情
     * @return 执行结果
     */
    int update(UserPointDto dto);

    /**
     * 获取用户积分详情
     *
     * @param companyId  公司Id
     * @param liveUserId 用户Id
     * @return 用户积分详情
     */
    UserPointDto findByCompanyIdAndLiveUserId(Long companyId, Long liveUserId);

}
