package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.UserPointDto;

/**
 * @author zhuenhui
 * @date 2022-03-30 11：09
 * @description 用户积分记录 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointService {

    /**
     * 新增
     *
     * @param dto 用户积分详情
     * @return 主键Id
     */
    Long insert(UserPointDto dto);

    /**
     * 更新
     *
     * @param dto 用户积分详情
     * @return 执行结果
     */
    int update(UserPointDto dto);

    /**
     * 获取用户积分详情
     *
     * @param companyId  公司Id
     * @param liveUserId 用户Id
     * @return 用户积分详情
     */
    UserPointDto findByCompanyIdAndLiveUserId(Long companyId, Long liveUserId);

    /**
     * 更新用户积分 - 每日签到
     *
     * @param id           用户积分Id
     * @param pointNum     积分数
     * @param oldPointNum  旧积分数
     * @param signInNum    累计签到天数
     * @param oldSignInNum 旧累计签到天数
     * @return 更新结果
     */
    int updateUserPointAndSignInDay(Long id, Integer pointNum, Integer oldPointNum,
                                    Integer signInNum, Integer oldSignInNum);

}
