package cn.com.duiba.live.activity.center.api.dto.user.point.consume;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author ouyang
 * @date 2022-04-24 11：09
 * @description 用户消费积分纪录 Dto
*/
@Data
public class UserPointConsumeRecordDto implements Serializable {

    private static final long serialVersionUID = -3200408116063448000L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 公司Id
    */
    private Long companyId;

    /**
    * 直播用户Id
    */
    private Long liveUserId;

    /**
    * 扣减积分数
    */
    private Integer decrPointNum;

    /**
    * 订单状态
    * @see cn.com.duiba.live.activity.center.api.enums.user.point.UserPointConsumeOrderStatusEnum
    */
    private Integer orderStatus;

    /**
    * 流水记录id(扣减通知回调成功后关联)
    */
    private Long userPointRecordId;

    /**
    * 订单业务方类型
    * @see cn.com.duiba.live.activity.center.api.enums.user.point.UserPointConsumeBizTypeEnum
    */
    private Integer bizType;

    /**
    * 业务方订单id 
    */
    private String bizId;

    /**
    * 业务订单信息
    */
    private String bizJson;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

