package cn.com.duiba.live.activity.center.api.param.right;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * Created by hong
 * time 2021/11/30.
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RightsRecordParam implements Serializable {

    private static final long serialVersionUID = -5708997147807202368L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 权益集合表主键id
     */
    private Long creditRightsId;

    /**
     * 1-直播间权益 2-信用卡权益 3-活动
     */
    private List<Integer> rightTypes;

    /**
     * 权益管理id或者信用卡活动id
     */
    private String nameId;

    /**
     * 图片地址
     */
    private String activityIcon;

    /**
     * 展示方式
     */
    private String displayMode;
}
