package cn.com.duiba.live.activity.center.api.remoteservice.answer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.answer.QuestionBankDto;
import cn.com.duiba.live.activity.center.api.param.answer.AnswerQuestionQueryParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserAnswerQuestionService {

    /**
     * 新增题目
     * @param dto
     * @return 执行结果
     */
    int save(QuestionBankDto dto);

    /**
     * 编辑题目
     * @param dto
     * @return 执行结果
     */
    int updateById(QuestionBankDto dto);


    QuestionBankDto queryById(Long questionId);

    /**
     * 根据条件分页查询
     * @param queryParam
     * @return
     */
    List<QuestionBankDto> listByParam(AnswerQuestionQueryParam queryParam);

    /**
     * 根据id批量查询
     * @param ids
     * @return
     */
    List<QuestionBankDto> listByIds(List<Long> ids);

    /**
     * 删除题目
     * @param questionId
     * @return
     */
    int deleteById(Long questionId);
}
