package cn.com.duiba.live.activity.center.api.remoteservice.retained;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.retained.RetainedRedRecordDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/4/6 11:44 上午
 */
@AdvancedFeignClient
public interface RemoteRetainedRedRecordService {

    RetainedRedRecordDto findByConfIdAndUserId(Long confId,Long userId);

    List<RetainedRedRecordDto> findByConfIdListAndUserId(List<Long> confIdList, Long userId);

    Long insert(RetainedRedRecordDto retainedRedRecordDto);

    /**
     * 调用mq 发红包
     * @param liveId
     * @param liveUserId
     * @param amount
     */
    Boolean sendRed(Long liveId,Long liveUserId,Integer amount,String ip);


    /**
     * 调用mq 发红包 停留福袋专用
     * @param liveId
     * @param liveUserId
     * @param amount
     */
    Boolean sendRedForRetained(Long liveId,Long liveUserId,Integer amount,String ip, Long confId);
}
