/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum UserPointChannelEnum {
    DAILY_SIGN_IN(1, "\u6bcf\u65e5\u7b7e\u5230"),
    SIGN_IN_SHARE(2, "\u7b7e\u5230\u5206\u4eab\u7ffb\u500d"),
    MANUAL_ADJUST(4, "\u624b\u52a8\u8c03\u6574"),
    FIRST_SIGN_IN(5, "\u9996\u7b7e\u5956\u52b1"),
    CONSUME(3, "\u79ef\u5206\u6d88\u8d39"),
    CMS_ADD(6, "\u79ef\u5206\u589e\u52a0"),
    ANSWER(7, "\u7b54\u9898\u79ef\u5206"),
    ANSWER_SHARE(8, "\u7b54\u9898\u5206\u4eab");

    private final Integer type;
    private final String desc;
    private static final Map<Integer, UserPointChannelEnum> ENUM_MAP;

    public static UserPointChannelEnum getByChannel(Integer channel) {
        if (NumberUtil.isNullOrLteZero(channel)) {
            return null;
        }
        return ENUM_MAP.get(channel);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private UserPointChannelEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(UserPointChannelEnum.values()).collect(Collectors.toMap(UserPointChannelEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

