package cn.com.duiba.live.activity.center.api.dto.fission.achieve;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播间用户免费领记录
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class LiveFissionAchieveRecordDto implements Serializable {

    private static final long serialVersionUID = -3820802964078605002L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间活动ID
     */
    private Long liveActivityId;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播用户ID
     */
    private Long liveUserId;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
     * 状态变更时间
     */
    private Date statusTime;
    /**
     * @see cn.com.duiba.live.activity.center.api.enums.fission.FissionAchieveStatusEnum
     * 活动状态：1-进行中 2-切换商品 3-待领取 4-已完成
     */
    private Integer activityStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


}

