package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/06/29 2:50 下午
 * @description 活动配置开关
 */
@Getter
@AllArgsConstructor
public enum ActivityConfStatusEnum {

    CLOSED(1, "未开启"),
    OPEN(2, "已开启"),
    OFF_SHELF(3, "已下架")
    ;

    private final Integer status;
    private final String desc;

    private static  final Map<Integer, ActivityConfStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(ActivityConfStatusEnum.values()).collect(Collectors.toMap(ActivityConfStatusEnum::getStatus, Function.identity()));
    }

    public static ActivityConfStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
