package cn.com.duiba.live.activity.center.api.dto.fission.blindbox;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author chenhang
 * @date 2021/11/26 3:22 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BlindBoxGoodsConfigDto implements Serializable {

    private static final long serialVersionUID = -6564971981119585939L;


    /**
     * 盲盒id
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 活动id   tb_fission_activity  id
     */
    private Long activityId;

    /**
     * 盲盒类型 0:免费领
     */
    private Integer blindType;

    /**
     * 邀请人数
     */
    private Integer inviteNum;

    /**
     * c端活动标题图片
     */
    private String titleImage;

    /**
     * 商品列表
     */
    private List<BlindBoxGoodsDto> goodsInfo;

}
