package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/12/3 3:15 下午
 */
@Getter
@AllArgsConstructor
public enum BlindBoxAccessStatusEnum {
    Access_Status_NO(0, "未访问活动"),
    Access_Status_YES(1, "访问过活动");


    private final Integer status;
    private final String desc;

    private static  final Map<Integer, BlindBoxReceiveStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(BlindBoxReceiveStatusEnum.values()).collect(Collectors.toMap(BlindBoxReceiveStatusEnum::getStatus, Function.identity()));
    }

    public static BlindBoxReceiveStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
