package cn.com.duiba.live.activity.center.api.enums.guide;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2020/12/9 10:43
 */
public enum GuideNodeBoomTypeEnum {
    /**
     * 预热轴爆款预约类型
     */
    ORDER(1, "初始状态"),
    NEWEST(2, "最新上架"),
    BOOM(3, "最多预约"),
    ;

    Integer boomType;

    String desc;

    GuideNodeBoomTypeEnum(Integer boomType, String desc) {
        this.boomType = boomType;
        this.desc = desc;
    }
    private static final Map<Integer, GuideNodeBoomTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(GuideNodeBoomTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getBoomType(), tmp);
        }
    }

    public static GuideNodeBoomTypeEnum getByType(Integer boomType) {
        return ENUM_MAP.get(boomType);
    }


    public Integer getBoomType() {
        return boomType;
    }

    public String getDesc() {
        return desc;
    }
}
