package cn.com.duiba.live.activity.center.api.remoteservice.answer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.answer.AnswerActivityDto;
import cn.com.duiba.live.activity.center.api.param.answer.AnswerActivityQueryParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteUserAnswerActivityService {


    /**
     * 新增
     * @param answerActivityDto
     * @return
     */
    int insert(AnswerActivityDto answerActivityDto);

    /**
     * 编辑
     * @param answerActivityDto
     * @return
     */
    int updateById(AnswerActivityDto answerActivityDto);

    /**
     * 查询详情
     * @param activityId
     * @return
     */
    AnswerActivityDto queryById(Long activityId);

    /**
     * 条件分页查询
     * @param param
     * @return
     */
    List<AnswerActivityDto> listByParam(AnswerActivityQueryParam param);

    /**
     * 条件查询总数
     * @param param
     * @return 总数
     */
    Long selectCount(AnswerActivityQueryParam param);
}
