package cn.com.duiba.live.activity.center.api.enums.conf;


import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Getter
public enum AssociatedGoodsTypeEnum {
    SUB_PAGE(1,"预约页面商品")
    ;


    private Integer type;

    private String desc;

    AssociatedGoodsTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, AssociatedGoodsTypeEnum> ENUM_MAP = new HashMap<>();


    static {
        for (AssociatedGoodsTypeEnum linkToType : values()) {
            ENUM_MAP.put(linkToType.getType(), linkToType);
        }
    }

    public static AssociatedGoodsTypeEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (AssociatedGoodsTypeEnum enumVal : AssociatedGoodsTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }

}
