package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/12/21 5:03 下午
 */
@Getter
@AllArgsConstructor
public enum FissionAchieveTypeEnum {
    FISSION_ACHIEVE_MULTI(0, "多阶段"),
    FISSION_ACHIEVE_SINGLE(1, "单阶段");


    private final Integer status;
    private final String desc;

    private static  final Map<Integer, BlindBoxGoodsStockStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(BlindBoxGoodsStockStatusEnum.values()).collect(Collectors.toMap(BlindBoxGoodsStockStatusEnum::getStatus, Function.identity()));
    }

    public static BlindBoxGoodsStockStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
