package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Description
 * @Date 2022/6/9 17:16
 * @Author LuHui
 */
@Getter
@AllArgsConstructor
public enum UserPointAddOrderStatusEnum {

    INIT(1, "订单初始化"),
    SUCCESS(2, "订单增加成功"),
    FAIL(3, "订单增加失败"),
    ;

    /**
     * 状态
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 枚举Map K：type V：枚举
     */
    private static final Map<Integer, UserPointConsumeOrderStatusEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(UserPointConsumeOrderStatusEnum.values()).collect(Collectors.toMap(UserPointConsumeOrderStatusEnum::getType, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据类型查询枚举
     */
    public static UserPointConsumeOrderStatusEnum getByStatus(Integer status) {
        if (NumberUtil.isNullOrLteZero(status)) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
