package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/03/30 13:55
 * @description 用户积分变化渠道渠道
 */
@Getter
@AllArgsConstructor
public enum UserPointChannelEnum {

    //累加
    DAILY_SIGN_IN(1, "每日签到"),
    SIGN_IN_SHARE(2, "签到分享翻倍"),
    MANUAL_ADJUST(4, "手动调整"),
    FIRST_SIGN_IN(5, "首签奖励"),
    //消费
    CONSUME(3, "积分消费"),
    ADD(6, "积分增加"),
    ANSWER(7,"答题积分"),
    ANSWER_SHARE(8,"答题分享")



    ;

    /**
     * 渠道类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 枚举Map K：channel V：枚举
     */
    private static final Map<Integer, UserPointChannelEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(UserPointChannelEnum.values()).collect(Collectors.toMap(UserPointChannelEnum::getType, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据类型查询枚举
     */
    public static UserPointChannelEnum getByChannel(Integer channel) {
        if (NumberUtil.isNullOrLteZero(channel)) {
            return null;
        }
        return ENUM_MAP.get(channel);
    }

}
