package cn.com.duiba.live.activity.center.api.dto.fission.blindbox;

import cn.com.duiba.live.activity.center.api.constant.BlindBoxUserRecordHashKeyConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @author chenhang
 * @date 2021/11/29 2:15 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BlindBoxUserRecordDto implements Serializable {

    private static final long serialVersionUID = 1521754529144617707L;

    /**
     * 盲盒id
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.BLIND_BOX_ID)
    private Long blindBoxId;

    /**
     * 幸运商品id
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.LUCK_GOODS_ID)
    private Long luckGoodsId;

    /**
     * 用户领取状态 0:未领取 1：已领取
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.RECEIVE_STATUS)
    private Integer receiveStatus;

    /**
     * 剩余试抽奖次数
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.LEFT_TRY_COUNT)
    private Integer leftTryCount;

    /**
     * 新增邀请人数
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.ADD_INVITE_COUNT)
    private Integer addInviteCount;

    /**
     * 助力次数
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.HELP_NUM)
    private Integer helpNum;


    /**
     * 幸运卡生效时间，毫秒
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.LUCK_START_TIME)
    private Long luckStartTime;

    /**
     * 访问活动状态 0:未访问 1:访问
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.ACCESS_STATUS)
    private Integer accessStatus;

    /**
     * 领取的商品id
     */
    @JSONField(name = BlindBoxUserRecordHashKeyConstant.RECEIVE_GOODS_ID)
    private Long receiveGoodsId;



}
