package cn.com.duiba.live.activity.center.api.enums.fission;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2021/8/5 21:34
 */
public enum FissionAchieveStatusEnum {
    /**
     * 1-进行中 2-切换商品 3-待领取 4-已完成
     */
    INVITING(1, "进行中"),
    CHANGE(2, "切换商品"),
    NOT_DRAW(3, "待领取"),
    FINISH(4, "已完成"),
    STEP_FIRST(5, "一阶段达成"),
    REFUSE_CHANGE(6, "拒绝切换"),
    FIRST_REFUSE_CHANGE(7, "一阶段达成拒绝切换"),
    ;

    Integer activityStatus;

    String desc;

    FissionAchieveStatusEnum(Integer activityStatus, String desc) {
        this.activityStatus = activityStatus;
        this.desc = desc;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public String getDesc() {
        return desc;
    }
    private static final Map<Integer, FissionAchieveStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(FissionAchieveStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getActivityStatus(), tmp);
        }
    }

    private static final Set<Integer> PROCESS_STATUS = Sets.newHashSet(
            FissionAchieveStatusEnum.INVITING.getActivityStatus(),
            FissionAchieveStatusEnum.STEP_FIRST.getActivityStatus(),
            FissionAchieveStatusEnum.REFUSE_CHANGE.getActivityStatus(),
            FissionAchieveStatusEnum.FIRST_REFUSE_CHANGE.getActivityStatus()
    );

    private static final Set<Integer> REFUSE_CHANGE_STATUS = Sets.newHashSet(
            FissionAchieveStatusEnum.REFUSE_CHANGE.getActivityStatus(),
            FissionAchieveStatusEnum.FIRST_REFUSE_CHANGE.getActivityStatus()
    );

    private static final List<Integer> ALL_STATUS = Lists.newArrayList(
            FissionAchieveStatusEnum.INVITING.getActivityStatus(),
            FissionAchieveStatusEnum.CHANGE.getActivityStatus(),
            FissionAchieveStatusEnum.NOT_DRAW.getActivityStatus(),
            FissionAchieveStatusEnum.FINISH.getActivityStatus(),
            FissionAchieveStatusEnum.STEP_FIRST.getActivityStatus(),
            FissionAchieveStatusEnum.REFUSE_CHANGE.getActivityStatus(),
            FissionAchieveStatusEnum.FIRST_REFUSE_CHANGE.getActivityStatus()
            );

    public static FissionAchieveStatusEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static boolean isProcess(Integer activityStatus){
        return PROCESS_STATUS.contains(activityStatus);
    }

    public static boolean isRefuseChange(Integer activityStatus){
        return REFUSE_CHANGE_STATUS.contains(activityStatus);
    }
}
