package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum{

    LIVE_USER_MP(9, "直播用户端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_USER_MP;
        }
    },

    LIVE_ANCHOR_MP(10, "直播主端") {
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.LIVE_ANCHOR_MP;
        }
    },

    ;
    private Integer type;
    private String desc;

    OATypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values()) {
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();
}
