package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;
import cn.com.duiba.kjy.api.dto.UserExtDto;
import cn.com.duiba.kjy.api.dto.user.UserIdLiveUserIdDto;
import cn.com.duiba.kjy.api.dto.user.UserIdOpenIdDto;
import cn.com.duiba.kjy.api.dto.user.UserOpenIdDto;
import cn.com.duiba.kjy.api.params.user.UpdateAccessToken;
import cn.com.duiba.kjy.api.params.user.UserExtSearchParam;

import java.util.List;

/**
 * Created by dugq on 2019-06-14.
 */
@AdvancedFeignClient
public interface RemoteUserExtService {
    @Deprecated
    List<UserExtDto> selectByUserId(Long userId);

    @Deprecated
    UserExtDto selectMpExtByUserId(Long userId);

    @Deprecated
    UserExtDto selectByUserIdAndOaId(Long userId, Long oaId);

    /**
     * 查询session_key
     * @param userId 用户ID
     * @param oaId oa主键
     * @return session_key
     */
    @Deprecated
    String findSessionKeyByUserIdAndOaId(Long userId, Long oaId);

    /**
     * extType = OA 非VIP公众号和用户的关联关系 List
     * extType = VIP VIP公众号和用户的关联关系 List
     * extType = VIP_OA VIP非VIP公众号和用户的关联关系 List
     * @param userId  用户id
     * @param extTypeEnum
     * @return
     */
    @Deprecated
    List<UserExtDto> selectOaByUserIdAndOaType(Long userId, UserExtTypeEnum extTypeEnum);

    /**
     * extType = OA   where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP  where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP_OA 优先VIP，VIP为空，返回OA
     * @param userId
     * @param extTypeEnum
     * @return
     */
    @Deprecated
    UserExtDto selectUsingOaByUserIdAndOaType(Long userId, UserExtTypeEnum extTypeEnum);

    /**
     * extType = OA   where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP  where subscribe = 1 and using = 1 and extType = oa
     * extType = VIP_OA 优先VIP，VIP为空，返回OA
     * @param userIds
     * @param extType
     * @return
     */
    @Deprecated
    List<UserExtDto> findUsingExtByUserIdsAndType(List<Long> userIds, UserExtTypeEnum extType);

    /**
     * 根据openId，查询扩展信息
     * @param openId 用户的标识，对当前公众号唯一
     * @return 扩展信息
     */
    UserExtDto findByOpenId(String openId);

    /**
     * 根据id主键更新 ext信息
     * @param dto
     * @return
     */
    Integer updateWxExt(UserExtDto dto);


    Integer updateLiveUserId(UserIdLiveUserIdDto dto);

    /**
     * 批量查询openId
     * @param userIds 用户ID集合
     * @param extType 类型
     * @see cn.com.duiba.kjy.api.constant.UserExtTypeEnum
     * @return 用户openId
     */
    @Deprecated
    List<UserOpenIdDto> findOpenIdByIds(List<Long> userIds, String extType);

    /**
     * 根据open ID查询
     * @param openIds
     * @return
     */
    List<UserIdOpenIdDto> selectIdByOpenIds(List<String> openIds);

    /**
     * 批量新增
     * @param usersExtDtoList
     * @return
     */
    Integer batchInsert(List<UserExtDto> usersExtDtoList);

    /**
     * 批量跟新accessToken 小程序时 指的是 sessionKey
     * @param updateAccessTokens
     * @return
     */
    Integer batchUpdateAccessToken(List<UpdateAccessToken> updateAccessTokens);


    /**
     * 批量查询openId
     * @param liveUserIds 用户ID集合
     * @param extType 类型
     * @see cn.com.duiba.kjy.api.constant.UserExtTypeEnum
     * @return 用户openId
     */
    List<UserOpenIdDto> findOpenIdByLiveUserIds(List<Long> liveUserIds, String extType);


    /**
     * 根据条件查询
     * @param params 查询条件
     * @return 列表
     */
    List<UserExtDto> queryByParam(UserExtSearchParam params);


}
