package cn.com.duiba.kjy.livecenter.api.dto.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播用户表
 * @author kjj mybatis generator
 * @date 2020-03-28
 */
@Data
public class LiveUserDto implements Serializable {

    private static final long serialVersionUID = 15853608937994082L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务方类型
     */
    private Integer bizType;

    /**
     * 业务方用户ID
     */
    private String bizUserId;

    /**
     * 用户的头像
     */
    private String avatar;

    /**
     * 用户的昵称
     */
    private String nickname;

    /**
     * 用户手机号
     */
    private String phone;

    /**
     * 小程序授权拿到的手机号
     */
    private String authPhone;

    /**
     * 是否授权手机号，1-授权，0-未授权
     */
    private Integer authPhoneStatus;

    /**
     * 中奖信息
     */
    private String bizParam;

    /**
     * 唯一ID，同一主体下唯一
     */
    private String unionId;

    /**
     * 用户性别，1=男性，2=女性，0=未知
     */
    private Integer gender;

    /**
     * 用户所在国家
     */
    private String country;

    /**
     * 用户所在省
     */
    private String province;

    /**
     * 用户所在市
     */
    private String city;

    /**
     * 备注
     */
    private String remark;

    /**
     * 微信用户的语言
     */
    private String lang;

    /**
     * 昵称拼音
     */
    private String nicknamePy;

    /**
     * 昵称拼音首字母
     */
    private String nicknamePyFast;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
