package cn.com.duiba.kjy.livecenter.api.dto.agent;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 代理人邀约任务
 * @author sunyan
 */
@Data
public class AgentAptaskDto implements Serializable {
    private static final long serialVersionUID = -5114283684873455551L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 任务一限额
     */
    private Integer t1RedLimit;

    /**
     * 任务一已发放
     */
    private Integer t1RedGrant;

    /**
     * 任务一红包最小金额
     */
    private Integer t1AmountMin;

    /**
     * 任务一红包最大金额
     */
    private Integer t1AmountMax;

    /**
     * 任务二限额
     */
    private Integer t2RedLimit;

    /**
     * 任务二已发放
     */
    private Integer t2RedGrant;

    /**
     * 任务二红包最小金额
     */
    private Integer t2AmountMin;

    /**
     * 任务二红包最大金额
     */
    private Integer t2AmountMax;

    /**
     * 任务二邀约人数
     */
    private Integer t2ApNum;

    /**
     * 任务三奖品名称
     */
    private String t3Title;

    /**
     * 任务三奖品图片(按,分割)
     */
    private String t3Images;

    private Boolean deleted;

    private Date gmtCreate;

    private Date gmtModified;

}