package cn.com.duiba.kjy.livecenter.api.dto.clue;

import cn.com.duiba.kjy.livecenter.api.enums.clue.LiveClueRewardWinningTypeEnum;
import cn.com.duiba.kjy.livecenter.api.enums.live.LiveInteractTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播线索-奖励领取记录
 * @author kjj mybatis generator 
 * @date 2020-04-03
 */
@Data
@ToString
public class LiveClueRewardDto implements Serializable {
     
    private static final long serialVersionUID = 15859185684586013L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 奖励ID
     */
    private Long rewardId;

    /**
     * 奖励类型：1-资料，2-关注直播间，3-累计观看，4-邀请好友，5-免费领，6-抢权益
     * @see LiveInteractTypeEnum
     */
    private Integer rewardType;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 抽奖码ID
     */
    private Long lotteryCodeId;

    /**
     * 抽奖码
     */
    private String lotteryCode;

    /**
     * 直播互动配置id，对应tb_live_interact_conf.id
     */
    private Long confId;

    /**
     * 中奖类型 0:直播中中奖,1:直播前中奖,2:指定中奖
     * @see LiveClueRewardWinningTypeEnum
     */
    private Integer winningType;

    /**
     * 中奖信息
     */
    private String bizParam;

    /**
     * 领奖状态
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.LiveClueRewardStatusEnum
     */
    private Integer rewardStatus=0;

    /**
     * 数据创建时间啊
     */
    private Date gmtCreate;

}