package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * 区别原有的红包发放查询业务 与rewardId一起使用
 * 后续业务在此枚举中新增
 */
public enum LiveRedPacketReciveRewardTypeEnum {
    DEFAULT(0,"默认，客吉吉原红包逻辑","A"),
    WELFARE_RAIN(1,"福利雨","B"),
    APTASK_T1(2,"代理人邀约任务一","C"),
    APTASK_T2(3,"代理人邀约任务二","D"),
    ;

    private Integer code;
    private String desc;
    private String type;

    LiveRedPacketReciveRewardTypeEnum(Integer code, String desc, String type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }

    private static final Map<Integer, LiveRedPacketReciveRewardTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveRedPacketReciveRewardTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static LiveRedPacketReciveRewardTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getType(){return type;}


}
