package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

public enum WelfareRainTypeEnum {
    /**
     * 福利雨雨滴类型
     */
    OBJECT(1,"实物"),
    REDPACKET(2,"红包");

    Integer rainType;

    String desc;

    private static final Map<Integer, WelfareRainTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(cn.com.duiba.kjy.livecenter.api.enums.live.WelfareRainTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getRainType(), tmp);
        }
    }

    public static cn.com.duiba.kjy.livecenter.api.enums.live.WelfareRainTypeEnum getByType(Integer rainType) {
        return ENUM_MAP.get(rainType);
    }

    WelfareRainTypeEnum(Integer rainType, String desc) {
        this.rainType = rainType;
        this.desc = desc;
    }

    public Integer getRainType() {
        return rainType;
    }

    public String getDesc() {
        return desc;
    }
}
