package cn.com.duiba.kjy.livecenter.api.dto.liveInteract;

import cn.com.duiba.kjy.livecenter.api.enums.live.InteractTypeEnums;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播互动配置关联表
 * @author kjj mybatis generator 
 * @date 2020-04-02
 */
@Data
public class LiveInteractConfDto implements Serializable {
     
    private static final long serialVersionUID = 15858106053029433L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 互动id
     */
    private Long interactId;

    /**
     * 互动类型：1-资料，2-问题, 3-关注直播间，4-累计观看，5-邀请好友，6-免费领，7-抢权益, 13-福利雨
     */
    private Integer interactType;

    /**
     * 权益数量，-1为不限制数量
     */
    private Integer interactNum;

    /**
     * 开抢时间
     */
    private Date startTime;

    /**
     * 互动状态，1-未启用，2-已上架，3-已下架
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.InteractStatusEnums
     */
    private Integer interactStatus;

    /**
     * 剩余数量
     */
    private Integer surplusNum;

    /**
     * 开播几分钟后开始
     */
    private Integer afterMin;

    /**
     * 展示权益数量
     */
    private Integer showInteractNum;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 同直播间同类型互动排序
     */
    private Integer interactSort;

    /**
     * 配置类型
     * @see InteractTypeEnums
     */
    private Integer confType;

    /**
     * 配置类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.DrawTypeEnum
     */
    private Integer drawType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}