package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.agent.AgentAptaskRecordDto;

/**
 *  代理人邀约任务完成情况
 * @author sunyan
 * @date 2020/10/30
 */
@AdvancedFeignClient
public interface RemoteAgentAptaskRecordService {

    /**
     * 新增
     * @param agentAptaskRecordDto
     * @return
     */
    int insert(AgentAptaskRecordDto agentAptaskRecordDto);

    /**
     * 按ID查询
     * @param id
     * @return
     */
    AgentAptaskRecordDto selectById(Long id);

    /**
     * 按任务id和用户id查询
     * @param taskId
     * @param liveVisitorId
     * @return
     */
    AgentAptaskRecordDto selectByTaskAndUserId(Long taskId, Long liveVisitorId);

    /**
     * 更新查看状态
     * @param agentAptaskRecordDto
     * @return
     */
    int updateShow(AgentAptaskRecordDto agentAptaskRecordDto);
}
