package cn.com.duiba.kjy.livecenter.api.exception;

import cn.com.duiba.kjy.livecenter.api.bean.ErrorCodeInterface;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * Created by hong
 * time 2021/3/5.
 */
public abstract class BizChecker {
    public static void checkNotNull(Object o, ErrorCodeInterface code) throws BizException {
        if (o != null) {
            return;
        }
        throwException(code);
    }

    public static void checkIsTrue(boolean expression, ErrorCodeInterface code) throws BizException {
        if (expression) {
            return;
        }
        throwException(code);
    }

    public static void checkNotBlank(String test, ErrorCodeInterface code) throws BizException {
        if (StringUtils.isNotBlank(test)) {
            return;
        }
        throwException(code);
    }

    public static void checkGtZero(Number number, ErrorCodeInterface code) throws BizException {
        if (number != null) {
            if (number instanceof Integer && (Integer) number > 0) {
                return;
            }
            if (number instanceof Long && (Long) number > 0L) {
                return;
            }
            if (number instanceof Float && (Float) number > 0F) {
                return;
            }
            if (number instanceof Double && (Double) number > 0D) {
                return;
            }
        }
        throwException(code);
    }

    public static void checkNotEmpty(Collection collection, ErrorCodeInterface code) throws BizException {
        if (collection != null && collection.size() > 0) {
            return;
        }
        throwException(code);
    }

    public static void checkNotEmpty(Map map, ErrorCodeInterface code) throws BizException {
        if (map != null && map.size() > 0) {
            return;
        }
        throwException(code);
    }

    public static void throwException(ErrorCodeInterface code) throws BizException {
        throw new BizException(code.getDesc()).withCode(String.valueOf(code.getShortCode()));
    }
}
