package cn.com.duiba.kjy.livecenter.api.remoteservice.cardLibrary;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.cardLibrary.CardPreStockDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/3/4 2:42 下午
 */
@AdvancedFeignClient
public interface RemoteCardPreStockService {

    /**
     * 根据卡券库id查询该卡券库绑定的直播间数量
     * @param cardLibraryId
     * @return
     */
    Long countPreStock(Long cardLibraryId);


    /**
     * 扣减库存
     * @param liveId 直播间id
     * @param cardLibraryId 卡券库id
     * @param num 扣库存的数量
     * @param interactConfId 直播配置id
     * @param isAll isAll = false 库存足够全部扣除 库存不足扣除最大库存
     *              isAll = true 库存足够全部扣除 库存不足一个不扣
     * @return 扣除库存的数量
     */
    Integer decreaseAndReturnNum(Long liveId,Long cardLibraryId,Long interactConfId,Integer num,Boolean isAll);


    /**
     * 发放卡券给用户
     * @param cardLibraryId 卡券库id
     * @param ids 领奖记录表id列表
     */
    void issueCard(Long cardLibraryId, List<Long> ids);

    /**
     * 根据卡券库id查询所有创建直播的库存(不包括已结束直播)
     * @param cardLibraryId
     */
    List<CardPreStockDto> selectByCardLibraryIdExcludeCloseLive(Long cardLibraryId);

    /**
     * 插入
     */
    Integer insert(CardPreStockDto cardPreStockDto);

    /**
     * 更新
     */
    Integer update(CardPreStockDto cardPreStockDto);

    /**
     * 根据抽奖配置删除
     */
    Integer deleteByInteractConfId(Long interactConfId);
}
