package cn.com.duiba.kjy.livecenter.api.enums.live;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2020/10/15 11:33
 */
public enum DrawTypeEnum {
    CONTACT(2,"联系业务员领取"),
    ADDRESS(3,"填写收货地址领取");
    Integer drawType;
    String desc;

    DrawTypeEnum(Integer drawType, String desc) {
        this.drawType = drawType;
        this.desc = desc;
    }

    private static final Map<Integer, DrawTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(DrawTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getDrawType(), tmp);
        }
    }

    public static DrawTypeEnum getByCode(Integer drawType) {
        return ENUM_MAP.get(drawType);
    }

    public Integer getDrawType() {
        return drawType;
    }

    public String getDesc() {
        return desc;
    }
}
