package cn.com.duiba.kjy.livecenter.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveClueVisitDto;
import cn.com.duiba.kjy.livecenter.api.dto.clue.LiveUserVisitDurationDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveClueVisitSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveVisitEnterOutParam;
import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;

import java.util.List;
import java.util.Map;

/**
 * Created by dugq on 2020-04-03.
 */
@AdvancedFeignClient
public interface RemoteLiveClueVisitService {
    /**
     * 进入直播间，建立访问关系
     * @param param 用户信息
     * @return 增加条数
     */
    int enterLive(LiveVisitEnterOutParam param);

    /**
     * 用户进入直播间。 批量插入访问记录
     * @param liveId
     * @param params
     * @return
     */
    int batchEnterLive(Long liveId, List<LiveVisitEnterOutParam> params);

    /**
     * 退出直播间
     * @param param 用户信息
     * @return 修改条数
     */
    int outLive(LiveVisitEnterOutParam param);

    /**
     * 批量查询
     * @param param 查询条件
     * @return 符合条件的记录
     */
    List<LiveClueVisitDto> selectList(LiveClueVisitSearchParam param);

    /**
     * 批量查询
     * @param param 查询条件
     * @return 符合条件的数量
     */
    Long selectCount(LiveClueVisitSearchParam param);

    /**
     * 根据直播ID和访客ID观看访问记录
     * @param liveId 直播ID
     * @param liveVisitorId 访客ID
     * @return
     */
    LiveClueVisitDto selectByLiveIdAndVisitId(Long liveId, Long liveVisitorId);

    /**
     * 原子性增加用户访问时长
     * @param liveId 直播ID
     * @param liveVisitorId 用户ID
     * @param addDuration 增加时长
     * @return
     */
    int addDuration(Long liveId, Long liveVisitorId, Long addDuration);

    /**
     * 批量原子性增加用户访问时长
     * @param liveId 直播ID
     * @param liveVisitorIds 用户ID
     * @param addDuration 增加时长
     * @return
     */
    int batchUpdateDuration(Long liveId, List<Long> liveVisitorIds, Long addDuration);

    /**
     * 根据访客ID和直播间ID查询观看时长
     * @param liveVisitorId
     * @param liveId
     * @return
     */
    Long findDurationWithCache(Long liveVisitorId, Long liveId);

    /**
     * 根据直播ID查询用户的在线时长
     * @param liveId
     * @param liveVisitorIds
     * @return
     */
    List<LiveUserVisitDurationDto> findLiveUsersDuration(Long liveId,List<Long> liveVisitorIds);

    /**
     * 分页获取直播间观看时长最长的用户
     * 根据观看时长倒序排序
     * @param param
     * @return
     */
    List<LiveUserVisitDurationDto> pageFindTopDuration(LiveClueVisitSearchParam param);

    /**
     * 查询直播ID对应观看人数
     * @param liveIdList 直播ID集合
     * @return key：直播ID，value：观看人数
     */
    Map<Long, Long> getLiveVisitorNum(List<Long> liveIdList);
}
