package cn.com.duiba.kjy.livecenter.api.remoteservice.question;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveQuestion.QuestionDto;
import cn.com.duiba.kjy.livecenter.api.param.liveQuestion.QuestionPageQueryParam;

import java.util.List;

/**
 * 直播问题rpc服务类
 * @author 吴文哲
 * @date 2020-04-01 13:49
 **/
@AdvancedFeignClient
public interface RemoteQuestionService {

    /**
     * 新增/修改问题
     * @param dto
     * @return
     */
    Long saveQuestion(QuestionDto dto);

    /**
     * 根据主键逻辑删除
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据主键查找
     * @param id
     * @return
     */
    QuestionDto findById(Long id);

    /**
     * 问题 分页查询
     * @param param
     * @return
     */
    List<QuestionDto> findByCondition(QuestionPageQueryParam param);

    /**
     * 根据ID列表查询所有的问题列表
     * @param ids
     * @return
     */
    List<QuestionDto> findByIds(List<Long> ids);
}
